
markup.push({

// MARK: sync

SyncDelayFormatter: {
	nsClass: "GXScaledFormatter", scale: -1, format: "% .0f ms"
},

SyncBlock:
{
	"+": "BlockTemplate",
	geNodeClass: "AHSyncNode",
	h4PresetsId: "SyncPresets",
	gxLibraryDescription: "Precise audio delay",
	gxTitle: "Sync",
	gxLibraryIcon: "library.delay",
	gxPopoverInfo: "SyncPopover",
	gxChildViews:
	{
	 	label: {
			"+": "LabelView.top.foreColorTheme1.size11",
			gxFrameRect: "12,45,96,22",
			gxDefaultValue: "Delay",
		},
		delay: {
			"+": "LabelView.blockReadout.top.size13",
			gxFrameRect: "12,60,96,22",
			gxFormatter: "SyncDelayFormatter",
			gxValueKey: "node.delay",
			axIsIgnored: false,
			axFormatter: "SyncDelayFormatter",
			axTitle: "Audio Delay",
		}
	}
},

	
// MARK: sync popover

SyncPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Sync",
	gxLayout: [
		"H:|-12-[self(284)]-12-|",
		"V:|-12-[self]-12-|",
		"V:|-41-[group]-8-[presetsGroup]"
	],
	gxCanDrawSubviewsIntoLayer: true,
	gxWantsLayer: true,
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		group:
		{
			"+": "GroupView",
			gxLayout: [
				"H:|-0-[self]-0-|",
				"V:|-18-[heading]-6-[slider]-16-|",
				
				"H:|-12-[heading]-(>=0)-[delayLeftLabel]-3-[delay(50)]-3-[delayRightLabel]-12-|&alignBaseline",
				"H:|-12-[slider]-12-|",
			],
			gxChildViews:
			{
				heading: labelView("Audio Delay", "size13.left"),
				delayLeftLabel: { "+": "LabelView.right.size13",	gxDefaultValue: "-" },
				delayRightLabel: { "+": "LabelView.left.size13", 	gxDefaultValue: "ms" },
				delay: {
					"+": "DarkNumberField",	
					gxNilWhenEmpty: false,
					gxRangeMin: 0,
					gxRangeMax: 1000,
					gxValueKey: "node.delay",
					axTitle: "Audio Delay",
					axHelp: "milliseconds",
				},
				slider: {
					"+": "SliderView",
					gxKeystrokeStepSize: 10,
					gxRangeMin: 0,
					gxRangeMax: 1000,
					gxValueKey: "node.delayStepped",
					axTitle: "Audio Delay",
					axFormatter: "SyncDelayFormatter",
				}
			}
		}
	}
},

	
})
